/*
 * This File is one of the examples from Java For Beginners
 * Do not reproduce this code for others or use it in a commercial setting without prior permission from the author.
 */

package chapter12;

import java.time.LocalDateTime;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;

/**
 *
 * @author Matthew Gregory
 * @website www.matthewgregory-author.com.au
 *
 */
public class Meeting {
    //A meeting is an array of people across the world (customers and employees) who want to get together.
    public Person host;
    public List<String> agendaItems= new ArrayList<>();
    public Set<Person> attendees=new TreeSet<>();
    public ZonedDateTime meetingDate;

    public Meeting(Person host, LocalDateTime meetingDate) {
        this.host=host;
        this.meetingDate = meetingDate.atZone(host.timezone);
    }
    
    public Meeting(Person host,Person... attendees){
        this.host=host;
        //assign the array to the field
        Collections.addAll(this.attendees, attendees);
    }
    
    public void displayMeetingDetails(){
        System.out.println("The host "+host.getFullName()+" welcomes you to the meeting.");
        System.out.println("This meeting is on "+meetingDate.toLocalDate()+" at "+meetingDate.toLocalTime());
        System.out.println("For your convenience we have converted the time to your timezone: ");
        for (Person attendee: attendees){
            System.out.println("Name: "+attendee.getFullName());
            ZonedDateTime adjustedTime=meetingDate.withZoneSameInstant(attendee.timezone);
            System.out.println("Time of meeting ("+attendee.timezone+"): "+adjustedTime.toLocalTime());
        }
        
        if (agendaItems.size() >=0){
            printAgenda();
        }
    }
    
    public void displayMeetingDate(){
        //Various formats
        //ISO standard formats
        DateTimeFormatter myFormatISO = DateTimeFormatter.ISO_ZONED_DATE_TIME;
        DateTimeFormatter myForamtISO2 = DateTimeFormatter.ISO_OFFSET_DATE;
        //Predifined Java formats
        DateTimeFormatter myFormatJAVA = DateTimeFormatter.ofLocalizedDateTime(FormatStyle.FULL);
        //Custom formats
        DateTimeFormatter myFormatCustom = DateTimeFormatter.ofPattern("EEEE, MMMM, YYYY dd, G, hh:mm A VV");
        //Print out a formatted version of the MeetingDate()
        System.out.println("Meeting Date: "+meetingDate.format(myFormatCustom));
    }
    
    public void printAgenda() {
        System.out.println("Items on the Agenda: ");
        for (int i = 0; i <= agendaItems.size()-1; i++) {
            System.out.println((i + 1) + ". " + agendaItems.get(i));
        }
    }

    public void printAttendees() {
        System.out.println("List of People Attending the Meeting, ");
        System.out.println();//Put a blank line between header and host.
        System.out.println("Hosted by: ");
        host.printDetails();
        System.out.println();//Put a blank line between host and attendees.
        System.out.println("Attendees: ");
        for (Person attendee : attendees) {
            //Note that you can make use of built-in methods and fields
            attendee.printDetails();//print out each persons details
        }
    }
    
    //Method added to print out meetings in format host:[attendees]+[agenda]+newline
    public String toString(){
        return host+": "+attendees+" "+agendaItems;
    }
   
    //Method to loop through attendees.
    @Deprecated
    public void processAttendees(){
        for (Person person: attendees){
            //Do something
            person.printDetails();
        }
    }
    
    //Same methoid accepting the task, but wrapped in an object
    @Deprecated
    public void processAttendees(Consumer<Person> task){
    for (Person person: attendees){
        //Do something
        task.accept(person);
    }

}
    
}
